/*
    module: smurf.h
    author: Marc Wolfgram
      date: 28Jun89
            20May90

*/
#define EMAX  64
#define IMAX  64
#define IMAXL 64L
#define TMAX  32
#define TMAXL 32L

struct gsos_str {
    int     len;
    char    str[255];
};

struct gsos_pfx {
    int     pCount,
            prefix;
    struct gsos_str *path;
};

struct minFinfo {
    int     pCount;
    struct gsos_str *path;
    int     access;
};

struct pt {
    int v, h;
};

struct tMember {
    char    *text, flag;
    int     rType;
};

struct iMember {
    char    *text, flag;
    long    rID;
    int     alias;
};

struct tList {
    int     pCount;
    long    ID;
    int     v1,h1,v2,h2;
    long    ProcRef;
    int     Flag, MoreFlags;
    long    RefCon;
    int     ListSize, ListView, ListType, ListStart;
    long    ListDraw;
    int     ListMemHeight, ListMemSize;
    struct  tMember *ListRef;
    long    colorTableRef;
};

struct iList {
    int     pCount;
    long    ID;
    int     v1,h1,v2,h2;
    long    ProcRef;
    int     Flag, MoreFlags;
    long    RefCon;
    int     ListSize, ListView, ListType, ListStart;
    long    ListDraw;
    int     ListMemHeight, ListMemSize;
    struct  iMember *ListRef;
    long    colorTableRef;
};

struct tCtlRec {
   CtlRecHndl ctlNext;
   GrafPortPtr ctlOwner;
   Rect ctlRect;
   Byte ctlFlag;
   Byte ctlHilite;
   Word ctlValue;           /* list start */
   LongProcPtr ctlProc;
   LongProcPtr ctlAction;
   Word ctlView;            /* list view  */
   Word ctlData;            /* list size  */
   LongWord ctlRefCon;
   LColorTablePtr ctlColor;
   VoidProcPtr ctlMemDraw;
   Word ctlMemHeight;
   Word ctlMemSize;
   struct tMember *ctlList;
   CtlRecHndl ctlListBar;
};

struct iCtlRec {
   CtlRecHndl ctlNext;
   GrafPortPtr ctlOwner;
   Rect ctlRect;
   Byte ctlFlag;
   Byte ctlHilite;
   Word ctlValue;
   LongProcPtr ctlProc;
   LongProcPtr ctlAction;
   Word ctlView;
   Word ctlData;
   LongWord ctlRefCon;
   LColorTablePtr ctlColor;
   VoidProcPtr ctlMemDraw;
   Word ctlMemHeight;
   Word ctlMemSize;
   struct iMember *ctlList;
   CtlRecHndl ctlListBar; /* Handle of list control's scroll bar control */
} ;

typedef struct WRefCon {
    word        winResType;
    long        winResID;
    int         winKind;
    GrafPortPtr windOwner;
} WRefCon, *WRefConPtr, **WRefConHndl;

#define CHILDSIZE 8L

typedef struct DepChild {
    word rType;
    long rID;
    word rNest;
} DepChild;

typedef struct ResDepRec {
    word        Version;
    word        Count;
    DepChild    Child[];
} *ResDepRecPntr, **ResDepRecHndl;

/*** THIS IS THE SMURF *******************************************************/

typedef struct Smurf {
             word wmWhat;               /* event record */
             long wmMessage,            /*      o       */
                  wmWhen,               /*      o       */
                  wmWhere;              /*      o       */
             word wmModifiers;          /*      o       */
             long wmTaskData,           /*      o       */
                  wmTaskMask,           /*      o       */
                  wmLastClickTick;      /*      o       */
             word wmClickCount;         /*      o       */
             long wmTaskData2,          /*      o       */
                  wmTaskData3,          /*      o       */
                  wmTaskData4,          /*      o       */
                  wmLastClickPt;        /*      o       */
             word TaskCode,             /* from taskmstr*/
                  EditCommand;          /* command 0..5 */
             long EditResult,           /* ed ret space */
                  EditResult2;          /* more space   */
             word EdUserID,             /* ed user ID   */
                  ResourceFileID,       /* (was MenuID) */
                  ResourceType;         /* ed res type  */
             long ResourceID;           /* ed res ID    */
             word ShellResFileID;
             long SMURFvector;

        struct pt GridOrigin,
                  GridDelta;
             word EditModifiers,
                  MoreModifiers,
                  EquateType;
             long EquateID,
                  *CoordProc,
                  *MarchProc;
} Smurf;

void pstrcpy(char *, char *);
